from obspy import read
import numpy as np

files = ["fdsnws-1.mseed","fdsnws-2.mseed","fdsnws-4.mseed","fdsnws-5.mseed"]

p_wave_arrival = 61.389 # first one only
s_wave_arrival = 77.2
s_wave_finished = 104.3

sample_rate = 100 # Hz

p_wave_buffer = []
s_wave_buffer = []

for file in files:
    st = read(file)
    print(st[0])

    for sample_i in range(len(st[0])):
        if sample_i >= p_wave_arrival*sample_rate and sample_i < s_wave_arrival*sample_rate:
            p_wave_buffer.append(st[0][sample_i])
        if sample_i >= s_wave_arrival*sample_rate and sample_i < s_wave_finished*sample_rate:
            s_wave_buffer.append(st[0][sample_i])

    st[0].write(f'{file}.wav', format='WAV', framerate=100)
    np.array(st[0], dtype=np.int32).tofile(f'{file}.bin')

# Convert lists to numpy arrays and save as binary files
p_wave_array = np.array(p_wave_buffer, dtype=np.int32)
s_wave_array = np.array(s_wave_buffer, dtype=np.int32)

p_wave_array.tofile('p_wave_sample.bin')
s_wave_array.tofile('s_wave_sample.bin')
